<?php
header('Content-Type: application/json; charset=utf-8');

// Database connection
$conn = mysqli_connect("localhost", "venmobdc_Job_news_BD", "2jIYt3OAA_jo", "venmobdc_job_news");
mysqli_set_charset($conn, "utf8");

// Check if POST request is received
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $input = json_decode(file_get_contents('php://input'), true);

    if ($input && isset($input['EPOS_ID']) && isset($input['Limit_Amount']) && isset($input['amount'])) {
        $EPOS_ID = $input['EPOS_ID'];
        $newLimitAmount = $input['Limit_Amount'];
        $newAmount = $input['amount'];

        // SQL query to update user details
        $stmt = $conn->prepare("UPDATE User_Details SET Limit_Amount = ?, amount = ? WHERE EPOS_ID = ?");
        $stmt->bind_param("dds", $newLimitAmount, $newAmount, $EPOS_ID);
        $stmt->execute();

        if ($stmt->affected_rows > 0) {
            echo json_encode(["status" => "success", "message" => "User balance updated"]);
        } else {
            echo json_encode(["status" => "error", "message" => "Failed to update user balance"]);
        }

        $stmt->close();
    } else {
        echo json_encode(["status" => "error", "message" => "Invalid input"]);
    }
} else {
    echo json_encode(["status" => "error", "message" => "Invalid request method"]);
}

$conn->close();
?>
