<?php
header('Content-Type: application/json; charset=utf-8');

// Database connection
$conn = mysqli_connect("localhost", "venmobdc_Job_news_BD", "2jIYt3OAA_jo", "venmobdc_job_news");
mysqli_set_charset($conn, "utf8");

// Check if POST request is received
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $input = json_decode(file_get_contents('php://input'), true);

    if ($input && isset($input['EPOS_ID']) && isset($input['deduct_amount'])) {
        $EPOS_ID = $input['EPOS_ID'];
        $deductAmount = $input['deduct_amount'];

        // SQL query to select user balance
        $stmt = $conn->prepare("SELECT Limit_Amount FROM User_Details WHERE EPOS_ID = ?");
        $stmt->bind_param("s", $EPOS_ID);
        $stmt->execute();
        $result = $stmt->get_result();

        if ($result->num_rows > 0) {
            // Fetch user data
            $userData = $result->fetch_assoc();
            $limitAmount = $userData['Limit_Amount'];

            if ($limitAmount >= $deductAmount) {
                $newLimitAmount = $limitAmount - $deductAmount;

                // SQL query to update user balance
                $updateStmt = $conn->prepare("UPDATE User_Details SET Limit_Amount = ? WHERE EPOS_ID = ?");
                $updateStmt->bind_param("ds", $newLimitAmount, $EPOS_ID);

                if ($updateStmt->execute()) {
                    echo json_encode(["status" => "success", "new_limit_amount" => $newLimitAmount]);
                } else {
                    echo json_encode(["status" => "error", "message" => "Failed to update balance"]);
                }

                $updateStmt->close();
            } else {
                echo json_encode(["status" => "error", "message" => "Insufficient balance"]);
            }
        } else {
            echo json_encode(["status" => "error", "message" => "User not found"]);
        }

        $stmt->close();
    } else {
        echo json_encode(["status" => "error", "message" => "Invalid input"]);
    }
} else {
    echo json_encode(["status" => "error", "message" => "Invalid request method"]);
}

$conn->close();
?>
