<?php
// Database connection
$servername = "localhost"; // assuming your database is hosted on localhost

// Connect to your database
$mysqli = new mysqli("localhost", "venmobdc_OnlineClassuser", "EuN&(VkTztyS", "venmobdc_OnlineClass");
// Assuming you're receiving user_id and book_id from your Android app
$user_id = $_GET['user_id'];
$book_id = $_GET['book_id'];

// Get current timestamp in UTC
$current_timestamp = gmdate("Y-m-d H:i:s");

// Check if the user already purchased the book
$query = "SELECT * FROM user_purchases WHERE user_id = ? AND book_id = ?";
$stmt = $mysqli->prepare($query);
$stmt->bind_param("ii", $user_id, $book_id);
$stmt->execute();
$result = $stmt->get_result();

$response = array();

if ($result->num_rows > 0) {
    // User already purchased the book
    $row = $result->fetch_assoc();
    $expiration_date = $row['expiration_date'];
    $purchase_date = $row['purchase_date']; // Retrieve purchase date from the database

    // Calculate time remaining
    $expiration_time = strtotime($expiration_date);
    $time_left_seconds = $expiration_time - strtotime($current_timestamp);
    $time_left_minutes = floor($time_left_seconds / 60);
    $time_left_days = floor($time_left_seconds / (60 * 60 * 24));

    if ($time_left_seconds > 0) {
        // Send success response with time remaining
        $response = array(
            "success" => true,
            "isPurchased" => true,
            "isValid" => true,
            "expiration_date" => $expiration_date,
            "purchase_date" => $purchase_date,
            "time_left_seconds" => $time_left_seconds,
            "time_left_minutes" => $time_left_minutes,
            "time_left_days" => $time_left_days
        );
    } else {
        // Purchase has expired, update the existing purchase record
        $query = "UPDATE user_purchases SET purchase_date = ?, expiration_date = ? WHERE user_id = ? AND book_id = ?";
        $stmt = $mysqli->prepare($query);
        
        // Calculate new expiration date (30 days from current timestamp)
        $new_expiration_date = gmdate("Y-m-d H:i:s", strtotime($current_timestamp . " +30 days"));
        
        $stmt->bind_param("ssii", $current_timestamp, $new_expiration_date, $user_id, $book_id);
        $stmt->execute();
        $stmt->close();
        
        // Send success response with updated expiration date
        $response = array(
            "success" => true,
            "isPurchased" => true,
            "isValid" => true,
            "expiration_date" => $new_expiration_date,
            "purchase_date" => $current_timestamp,
            "message" => "Purchase renewed successfully"
        );
    }
} else {
    // User has not purchased the book before, insert new purchase record
    $expiration_date = gmdate("Y-m-d H:i:s", strtotime($current_timestamp . " +30 days"));

    $query = "INSERT INTO user_purchases (user_id, book_id, purchase_date, expiration_date) VALUES (?, ?, ?, ?)";
    $stmt = $mysqli->prepare($query);
    $stmt->bind_param("iiss", $user_id, $book_id, $current_timestamp, $expiration_date);
    $stmt->execute();
    $stmt->close();

    // Send success response
    $response = array(
        "success" => true,
        "isPurchased" => true,
        "isValid" => true,
        "expiration_date" => $expiration_date,
        "purchase_date" => $current_timestamp,
        "message" => "Book purchased successfully"
    );
}

// Send response to Android app
echo json_encode($response);
?>