<?php
header('Content-Type: application/json; charset=utf-8');

// MySQLi connection details
$servername = "localhost";
$username = "venmobdc_OnlineClassuser";
$password = "EuN&(VkTztyS";
$database = "venmobdc_OnlineClass";

// Check API key
$apiKey = isset($_SERVER['HTTP_API_KEY']) ? $_SERVER['HTTP_API_KEY'] : '';
if ($apiKey !== '546554654dcsd65464') {
    http_response_code(403); // Forbidden
    echo json_encode(['message' => 'Invalid API Key']);
    exit();
}

// Get POST data
$data = json_decode(file_get_contents("php://input"), true);
$id = isset($data['id']) ? intval($data['id']) : 0; // Sanitize input to avoid SQL injection
$pointsToUpdate = isset($data['pointsToUpdate']) ? intval($data['pointsToUpdate']) : 0; // Sanitize input

// Create connection
$conn = new mysqli($servername, $username, $password, $database);

// Check connection
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

// Retrieve current points of the user
$sql = "SELECT point FROM User_Details WHERE id=?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $id);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows > 0) {
    $row = $result->fetch_assoc();
    $currentPoints = $row["point"];

    // Update points
    $updatedPoints = $currentPoints + $pointsToUpdate;

    $updateSql = "UPDATE User_Details SET point=? WHERE id=?";
    $updateStmt = $conn->prepare($updateSql);
    $updateStmt->bind_param("ii", $updatedPoints, $id);
    if ($updateStmt->execute()) {
        echo json_encode(['message' => 'Points updated successfully']);
    } else {
        echo json_encode(['message' => 'Error updating points: ' . $conn->error]);
    }
} else {
    echo json_encode(['message' => 'User not found']);
}

$stmt->close();
$updateStmt->close();
$conn->close();
?>
