<?php
header('Content-Type: application/json; charset=utf-8');

// MySQLi connection details
$servername = "localhost";
$username = "venmobdc_OnlineClassuser";
$password = "EuN&(VkTztyS";
$database = "venmobdc_OnlineClass";

// Check API key
$apiKey = isset($_SERVER['HTTP_API_KEY']) ? $_SERVER['HTTP_API_KEY'] : '';
if ($apiKey !== '546554654dcsd65464') {
    http_response_code(403); // Forbidden
    echo json_encode(['success' => false, 'message' => 'Invalid API Key']);
    exit();
}

// Get POST data
$data = json_decode(file_get_contents("php://input"), true);
$user_id = isset($data['user_id']) ? intval($data['user_id']) : 0; // Sanitize input to avoid SQL injection
$book_id = isset($data['book_id']) ? intval($data['book_id']) : 0; // Sanitize input

// Get current timestamp in UTC
$current_timestamp = gmdate("Y-m-d H:i:s");

// Create connection
$mysqli = new mysqli($servername, $username, $password, $database);

// Check connection
if ($mysqli->connect_error) {
    die("Connection failed: " . $mysqli->connect_error);
}

// Check if the user already purchased the book
$query = "SELECT * FROM user_purchases WHERE user_id = ? AND book_id = ?";
$stmt = $mysqli->prepare($query);
$stmt->bind_param("ii", $user_id, $book_id);
$stmt->execute();
$result = $stmt->get_result();

$response = array();

if ($result->num_rows > 0) {
    // User already purchased the book
    $row = $result->fetch_assoc();
    $expiration_date = $row['expiration_date'];
    $purchase_date = $row['purchase_date']; // Retrieve purchase date from the database

    // Calculate time remaining
    $expiration_time = strtotime($expiration_date);
    $time_left_seconds = $expiration_time - strtotime($current_timestamp);
    $time_left_minutes = floor($time_left_seconds / 60);
    $time_left_days = floor($time_left_seconds / (60 * 60 * 24));

    if ($time_left_seconds > 0) {
        // Send success response with time remaining
        $response = array(
            "success" => true,
            "isPurchased" => true,
            "isValid" => true,
            "expiration_date" => $expiration_date,
            "purchase_date" => $purchase_date,
            "time_left_seconds" => $time_left_seconds,
            "time_left_minutes" => $time_left_minutes,
            "time_left_days" => $time_left_days
        );
    } else {
        // Send response indicating purchase has expired
        $response = array(
            "success" => true,
            "isPurchased" => true,
            "isValid" => false,
            "message" => "Purchase expired. Please buy again."
        );
    }
} else {
    // Send response indicating the book has not been purchased
    $response = array(
        "success" => true,
        "isPurchased" => false,
        "isValid" => false,
        "message" => "You have not purchased this book yet."
    );
}

// Send response to Android app
echo json_encode($response);

$mysqli->close();
?>
