<?php
header("Content-Type: application/json");

// Security: API Key
$apiKey = "12345";
if (!isset($_POST['api_key']) || $_POST['api_key'] !== $apiKey) {
    echo json_encode(["success" => false, "message" => "Invalid API key"]);
    exit();
}

// Database credentials
$servername = "localhost";
$username = "venmobdc_OnlineClassuser";
$password = "EuN&(VkTztyS";
$dbname = "venmobdc_OnlineClass";

// Create a new connection
$conn = new mysqli($servername, $username, $password, $dbname);

// Check connection
if ($conn->connect_error) {
    echo json_encode(["success" => false, "message" => "Connection failed: " . $conn->connect_error]);
    exit();
}

// Check if user_id is provided
if (!isset($_POST['user_id'])) {
    echo json_encode(["success" => false, "message" => "User ID not provided"]);
    exit();
}

$user_id = $_POST['user_id'];

// Retrieve user points
$userPointsSql = "SELECT point FROM User_Details WHERE id = ?";
$stmt = $conn->prepare($userPointsSql);
$stmt->bind_param("i", $user_id);
$stmt->execute();
$stmt->store_result();
$stmt->bind_result($userPoints);
$stmt->fetch();

$response = array();
if ($stmt->num_rows > 0) {
    $response['success'] = true;
    $response['points'] = $userPoints;
} else {
    $response['success'] = false;
    $response['message'] = "User not found";
}

$stmt->close();
$conn->close();

echo json_encode($response);
?>
