<?php
header("Content-Type: application/json");

// Security: API Key
$apiKey = "12345";
if (!isset($_POST['api_key']) || $_POST['api_key'] !== $apiKey) {
    echo json_encode(["success" => false, "message" => "Invalid API key"]);
    exit();
}

// Database credentials
$servername = "localhost";
$username = "venmobdc_OnlineClassuser";
$password = "EuN&(VkTztyS";
$dbname = "venmobdc_OnlineClass";

// Create a new connection
$conn = new mysqli($servername, $username, $password, $dbname);

// Check connection
if ($conn->connect_error) {
    echo json_encode(["success" => false, "message" => "Connection failed: " . $conn->connect_error]);
    exit();
}

// Check if class_name and user_id are provided
if (!isset($_POST['class_name']) || !isset($_POST['user_id'])) {
    echo json_encode(["success" => false, "message" => "Class Name or User ID not provided"]);
    exit();
}

$class_name = $_POST['class_name'];
$user_id = $_POST['user_id'];

// Retrieve user's current points
$userPointsSql = "SELECT point FROM User_Details WHERE id = ?";
$stmt = $conn->prepare($userPointsSql);
$stmt->bind_param("i", $user_id);
$stmt->execute();
$stmt->store_result();
$stmt->bind_result($userPoints);
$stmt->fetch();
$stmt->close();

if ($stmt->num_rows == 0) {
    echo json_encode(["success" => false, "message" => "User not found"]);
    exit();
}

// Retrieve Need_Point for the given class_name
$classPointsSql = "SELECT Need_Point FROM class_purchases_point WHERE Class_Name = ?";
$stmt = $conn->prepare($classPointsSql);
$stmt->bind_param("s", $class_name);
$stmt->execute();
$stmt->store_result();
$stmt->bind_result($needPoints);
$stmt->fetch();
$stmt->close();

if ($stmt->num_rows == 0) {
    echo json_encode(["success" => false, "message" => "Class not found"]);
    exit();
}

// Compare points
$response = array();
if ($userPoints >= $needPoints) {
    $response['success'] = true;
    $response['message'] = "User has enough points.";
} else {
    $response['success'] = false;
    $response['message'] = "Insufficient points.";
}

// Close connection
$conn->close();

// Send the JSON response
echo json_encode($response);
?>
