<?php
header("Content-Type: application/json");

// Security: API Key
$apiKey = "12345";
if (!isset($_POST['api_key']) || $_POST['api_key'] !== $apiKey) {
    echo json_encode(["success" => false, "message" => "Invalid API key"]);
    exit();
}

// Database credentials
$servername = "localhost";
$username = "venmobdc_OnlineClassuser";
$password = "EuN&(VkTztyS";
$dbname = "venmobdc_OnlineClass";

// Create a new connection
$conn = new mysqli($servername, $username, $password, $dbname);

// Check connection
if ($conn->connect_error) {
    echo json_encode(["success" => false, "message" => "Connection failed: " . $conn->connect_error]);
    exit();
}

// Check if user_id and class_name are provided
if (!isset($_POST['user_id']) || !isset($_POST['class_name'])) {
    echo json_encode(["success" => false, "message" => "User ID or Class Name not provided"]);
    exit();
}

$user_id = $_POST['user_id'];
$class_name = $_POST['class_name'];

// Retrieve user points
$userPointsSql = "SELECT point FROM User_Details WHERE id = ?";
$stmt = $conn->prepare($userPointsSql);
$stmt->bind_param("i", $user_id);
$stmt->execute();
$stmt->store_result();
$stmt->bind_result($userPoints);
$stmt->fetch();
$stmt->close();

// Retrieve needed points for the class
$classPointsSql = "SELECT Need_Point FROM class_purchases_point WHERE Class_Name = ?";
$stmt = $conn->prepare($classPointsSql);
$stmt->bind_param("s", $class_name);
$stmt->execute();
$stmt->store_result();
$stmt->bind_result($needPoints);
$stmt->fetch();
$stmt->close();

// Compare points and prepare response
$response = array();
if ($stmt->num_rows > 0) {
    if ($userPoints >= $needPoints) {
        $response['success'] = true;
        $response['message'] = "Sufficient points";
    } else {
        $response['success'] = false;
        $response['message'] = "Insufficient points";
    }
} else {
    $response['success'] = false;
    $response['message'] = "Class not found";
}

// Close connection
$conn->close();

// Send the JSON response
echo json_encode($response);
?>
