<?php
$servername = "localhost";
$username = "venmobdc_Job_news_BD";
$password = "2jIYt3OAA_jo";
$dbname = "venmobdc_job_news";

// Create connection
$conn = new mysqli($servername, $username, $password, $dbname);

// Check connection
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

// Check if category parameter is set
if (isset($_GET['category'])) {
    $category = $_GET['category'];

    // Validate the category name to prevent SQL injection
    if (!preg_match("/^[a-zA-Z0-9_]+$/", $category)) {
        die("Invalid category name");
    }

    // Construct the table name dynamically
    $table_name = "alljob"; // Assuming data is in the 'alljob' table

    // Prepare and bind
    $stmt = $conn->prepare("SELECT text, image, url FROM $table_name WHERE category = ?");
    $stmt->bind_param("s", $category);

    // Execute statement
    $stmt->execute();

    // Bind result variables
    $stmt->bind_result($text, $image, $url);

    // Fetch values
    $result = array();
    while ($stmt->fetch()) {
        $row = array(
            "text" => $text,
            "image" => $image,
            "url" => $url
        );
        array_push($result, $row);
    }

    // Close statement
    $stmt->close();

    // Return JSON response
    header('Content-Type: application/json');
    echo json_encode($result);
} else {
    echo json_encode(array("error" => "Category not set"));
}

// Close connection
$conn->close();
?>
