<?php
header('Content-Type: application/json; charset=utf-8');

// Database connection
$conn = mysqli_connect("localhost", "venmobdc_Job_news_BD", "2jIYt3OAA_jo", "venmobdc_job_news");
mysqli_set_charset($conn, "utf8");

// Check if POST request is received
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $input = json_decode(file_get_contents('php://input'), true);

    $userId = $input['User_Id'];
    $password = $input['User_Password'];
    $workPlaceCode = $input['User_Work_Place_Code'];

    // SQL query to select user details including EPOS_ID and BlockOrNot
    $stmt = $conn->prepare("SELECT User_Address, EPOS_ID, User_Work_Place_Code, amount, BlockOrNot FROM User_Details WHERE User_Id = ? AND User_Password = ? AND User_Work_Place_Code = ?");
    $stmt->bind_param("sss", $userId, $password, $workPlaceCode);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows > 0) {
        // Fetch user data
        $userData = $result->fetch_assoc();
        if ($userData['BlockOrNot'] == 1) {
            echo json_encode(["status" => "blocked", "message" => "User is blocked"]);
        } else {
            echo json_encode(["status" => "success", "user" => $userData]);
        }
    } else {
        echo json_encode(["status" => "error", "message" => "Invalid credentials"]);
    }

    $stmt->close();
} else {
    echo json_encode(["status" => "error", "message" => "Invalid request method"]);
}

$conn->close();
?>
