<?php
header('Content-Type: application/json; charset=utf-8');

// Database connection
$conn = mysqli_connect("localhost", "venmobdc_Job_news_BD", "2jIYt3OAA_jo", "venmobdc_job_news");
mysqli_set_charset($conn, "utf8");

// Check if POST request is received
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $input = json_decode(file_get_contents('php://input'), true);

    if ($input && isset($input['EPOS_ID']) && isset($input['deduct_amount']) && isset($input['deposit_amount']) && isset($input['Deposit_U_ID'])) {
        $EPOS_ID = $input['EPOS_ID'];
        $deductAmount = $input['deduct_amount'];
        $depositAmount = $input['deposit_amount'];
        $depositUID = $input['Deposit_U_ID'];
        $currentTime = date('d-m-Y H:i:s');

        // SQL query to select user balance and amount
        $stmt = $conn->prepare("SELECT Limit_Amount, amount FROM User_Details WHERE EPOS_ID = ?");
        $stmt->bind_param("s", $EPOS_ID);
        $stmt->execute();
        $result = $stmt->get_result();

        if ($result->num_rows > 0) {
            // Fetch user data
            $userData = $result->fetch_assoc();
            $limitAmount = $userData['Limit_Amount'];
            $previousAmount = $userData['amount'];

            if ($limitAmount >= $deductAmount) {
                $newLimitAmount = $limitAmount - $deductAmount;
                $newAmount = $previousAmount + $depositAmount;

                // SQL query to update user balance and amount
                $updateStmt = $conn->prepare("UPDATE User_Details SET Limit_Amount = ?, amount = ? WHERE EPOS_ID = ?");
                $updateStmt->bind_param("dds", $newLimitAmount, $newAmount, $EPOS_ID);

                if ($updateStmt->execute()) {
                    // Insert the transaction record
                    $insertStmt = $conn->prepare("INSERT INTO User_Tranjection (EPOS_ID, Deposit_Amount, Deposit_U_ID, date, Approve_Status) VALUES (?, ?, ?, ?, 'PENDING')");
                    $insertStmt->bind_param("sdss", $EPOS_ID, $depositAmount, $depositUID, $currentTime);
                    $insertStmt->execute();
                    $insertStmt->close();

                    echo json_encode(["status" => "success", "new_limit_amount" => $newLimitAmount, "new_amount" => $newAmount]);
                } else {
                    echo json_encode(["status" => "error", "message" => "Failed to update balance and amount"]);
                }

                $updateStmt->close();
            } else {
                echo json_encode(["status" => "error", "message" => "Insufficient balance"]);
            }
        } else {
            echo json_encode(["status" => "error", "message" => "User not found"]);
        }

        $stmt->close();
    } else {
        echo json_encode(["status" => "error", "message" => "Invalid input"]);
    }
} else {
    echo json_encode(["status" => "error", "message" => "Invalid request method"]);
}

$conn->close();
?>
