<?php

header('Content-Type: application/json; charset=utf-8');

// Your API key
$valid_api_key = "YOUR_API_KEY_HERE";

// Check for API key in the request headers
if (!isset($_SERVER['HTTP_API_KEY']) || $_SERVER['HTTP_API_KEY'] !== $valid_api_key) {
    http_response_code(403);
    echo json_encode(array("error" => "Invalid API key"));
    exit;
}

// Get the input data
$data = json_decode(file_get_contents("php://input"), true);

$app_version = isset($data['app_version']) ? $data['app_version'] : null;
$bdt_amount_text = isset($data['bdt_amount_text']) ? $data['bdt_amount_text'] : null;
$symble = isset($data['symble']) ? $data['symble'] : null;

$conn = mysqli_connect("localhost", "venmobdc_Job_news_BD", "2jIYt3OAA_jo", "venmobdc_job_news");

if (!$conn) {
    die("Connection failed: " . mysqli_connect_error());
}

mysqli_set_charset($conn, "utf8mb4");

$response = array();
$success = false;

// Update the apps_version if provided
if ($app_version !== null) {
    $sql = "UPDATE apps_details_update SET apps_version = ? WHERE id = 1";
    $stmt = mysqli_prepare($conn, $sql);
    mysqli_stmt_bind_param($stmt, "s", $app_version);
    $success = mysqli_stmt_execute($stmt);
    $response['apps_version'] = $success ? "Updated successfully" : "Failed to update";
}

// Update the BDT_amount_text if provided
if ($bdt_amount_text !== null) {
    $sql = "UPDATE apps_details_update SET BDT_amount_text = ? WHERE id = 1";
    $stmt = mysqli_prepare($conn, $sql);
    mysqli_stmt_bind_param($stmt, "s", $bdt_amount_text);
    $success = mysqli_stmt_execute($stmt);
    $response['bdt_amount_text'] = $success ? "Updated successfully" : "Failed to update";
}

// Update the symble if provided
if ($symble !== null) {
    $sql = "UPDATE apps_details_update SET symble = ? WHERE id = 1";
    $stmt = mysqli_prepare($conn, $sql);
    mysqli_stmt_bind_param($stmt, "s", $symble);
    $success = mysqli_stmt_execute($stmt);
    $response['symble'] = $success ? "Updated successfully" : "Failed to update";
}

mysqli_close($conn);

echo json_encode($response);

?>
