<?php
header("Content-Type: application/json");

$servername = "localhost";
$username = "venmobdc_OnlineClassuser";
$password = "EuN&(VkTztyS";
$dbname = "venmobdc_OnlineClass";

$conn = new mysqli($servername, $username, $password, $dbname);

if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

$api_key = $_POST['api_key'];
$valid_api_key = "46654cdc584654"; // Replace with your actual API key

if ($api_key !== $valid_api_key) {
    echo json_encode(array("status" => "error", "message" => "Invalid API key"));
    exit();
}

$user_id = intval($_POST['user_id']);
$book_id = intval($_POST['book_id']);
$required_points = intval($_POST['required_points']);

// Check if user has purchased the book and if the purchase is still valid
$sql = "SELECT * FROM user_purchases WHERE user_id = ? AND book_id = ? AND expiration_date > NOW()";
$stmt = $conn->prepare($sql);
$stmt->bind_param("ii", $user_id, $book_id);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows > 0) {
    $row = $result->fetch_assoc();
    $remaining_time = calculateRemainingTime($row['expiration_date']);
    echo json_encode(array("status" => "already_purchased", "remaining_time" => $remaining_time));
    exit();
}

// Check user points
$sql = "SELECT point FROM User_Details WHERE id = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $user_id);
$stmt->execute();
$result = $stmt->get_result();
$user = $result->fetch_assoc();

if ($user['point'] < $required_points) {
    echo json_encode(array("status" => "error", "message" => "Insufficient points"));
    exit();
}

// Deduct points and insert purchase record
$sql = "UPDATE User_Details SET point = point - ? WHERE id = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("ii", $required_points, $user_id);
if ($stmt->execute()) {
    $sql = "INSERT INTO user_purchases (user_id, book_id, purchase_date, expiration_date) VALUES (?, ?, NOW(), DATE_ADD(NOW(), INTERVAL 30 DAY))";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("ii", $user_id, $book_id);
    if ($stmt->execute()) {
        $expiration_date = new DateTime();
        $expiration_date->add(new DateInterval('P30D'));
        $remaining_time = calculateRemainingTime($expiration_date->format('Y-m-d H:i:s'));
        echo json_encode(array("status" => "success", "remaining_time" => $remaining_time));
        exit();
    } else {
        echo json_encode(array("status" => "error", "message" => "Purchase failed"));
        exit();
    }
} else {
    echo json_encode(array("status" => "error", "message" => "Point deduction failed"));
    exit();
}

$conn->close();

function calculateRemainingTime($expiration_date) {
    $now = new DateTime();
    $expiry = new DateTime($expiration_date);
    $interval = $now->diff($expiry);
    return $interval->format('%a days %h hours %i minutes %s seconds');
}
?>
